---
title: Contributing
weight: 32
menu:
  main:
    parent: Dev Guide
    identifier: Contributing
    weight: 12
---

## Conduct

It's simple really. Everything in the 
[Contributor Covenant](https://www.contributor-covenant.org/version/1/4/code-of-conduct)
 applies here. If, after
reading that, you are unclear, then please pick another project to work on. The
maintainers will not hesitate to enforce a code of conduct.

## License

NoSQLBench is licensed under the [Apache License, version
2.0](https://www.apache.org/licenses/LICENSE-2.0). If you wish to contribute
your code to this project, you must be willing to use this license. All code
contributed here is presumed to be licensed as such, and the maintainers
may add licenses to contributed files or add commit-level requirements for
clear licensing headers.

## How to Contribute

### Issue Tracker

There are multiple ways to contribute. This most direct and engaging way is to
file an issue when you have requests for enhancements or bug fixes.

Tickets which may be suitable for newer contributes will be marked as **easy
pick** in the spirit of encouragement.

### Project Site

The project site at nosqlbench.io could use some help as well. This is in a
separate repository adjacent to the main project as 'nosqlbench-docs'.
Consider this as part of the codebase in general. You can file issues against 
it, or submit pull requests.

### Pull Request

This project is eager to have contributors. To that end, pull requests which are
in the spirit of the project will be welcome. When pull requests are not
directly accepted, kind and specific explanation of why will be provided. If you
want to contribute, and are not sure about whether your improvements would be
accepted, simply file an issue and describe what you are interested in doing
before coding too much.

### Change Scoping

Like with **easy pick** issues, those which are likely to be more effort will be
marked as **needs design**. The goals of any **needs design** will be to propose
in more detail the moving parts and user-facing ideas which might be too complex
or opaque for a single coding and testing effort. Think of these as *epic*
ideas, which will, by their nature, be required to have some design and usage
documentation submitted before they are merged.

### Project Maturity

As nosqlbench matures, a more stringent set of code management practices will
be adopted. The maintainers are leaning towards the 
[Git Flow](https://nvie.com/posts/a-successful-git-branching-model/)
model. A stricter releas and branching model *will* be imposed as part of the next
major release.
