// This file is auto-generated.
package io.nosqlbench.virtdata.library.basics.shared.distributions;

import io.nosqlbench.nb.api.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class WeightedStringsFromCSVAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "WeightedStringsFromCSV";
  }

  public String getPackageName() {
    return "io.nosqlbench.virtdata.library.basics.shared.distributions";
  }

  public String getClassJavadoc() {
    return "Provides sampling of a given field in a CSV file according\n"
            + "to discrete probabilities. The CSV file must have headers which can\n"
            + "be used to find the named columns for value and weight. The value column\n"
            + "contains the string result to be returned by the function. The weight\n"
            + "column contains the floating-point weight or mass associated with the\n"
            + "value on the same line. All the weights are normalized automatically.\n"
            + "\n"
            + "<P>If there are multiple file names containing the same format, then they\n"
            + "will all be read in the same way.</P>\n"
            + "\n"
            + "<p>If the first word in the filenames list is 'map', then the values will not\n"
            + "be pseudo-randomly selected. Instead, they will be mapped over in some\n"
            + "other unsorted and stable order as input values vary from 0L to Long.MAX_VALUE.</p>\n"
            + "\n"
            + "<p>Generally, you want to leave out the 'map' directive to get \"random sampling\"\n"
            + "of these values.</p>\n"
            + "\n"
            + "<p>This function works the same as the three-parametered form of WeightedStrings,\n"
            + "which is deprecated in lieu of this one. Use this one instead.</p>\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "java.lang.String";
  }

  public Category[] getCategories() {
    return new Category[] { Category.general };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("WeightedStringsFromCSV", "Create a sampler of strings from the given CSV file. The CSV file must have plain CSV headers\n"
              + "as its first line.\n"
              + "@param valueColumn The name of the value column to be sampled\n"
              + "@param weightColumn The name of the weight column, which must be parsable as a double\n"
              + "@param filenames One or more file names which will be read in to the sampler buffer\n", 
            new LinkedHashMap<String, String>() {{
              put("valueColumn","java.lang.String");
              put("weightColumn","java.lang.String");
              put("filenames","java.lang.String[]...");
            }},
            new ArrayList<List<String>>() {{
            }}
          ));
        }};
  }
}
