// This file is auto-generated.
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.nb.api.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class StringMapAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "StringMap";
  }

  public String getPackageName() {
    return "io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection";
  }

  public String getClassJavadoc() {
    return "Create a {@code Map<String,String>} from a long input\n"
            + "based on three functions,\n"
            + "the first to determine the map size, and the second to populate\n"
            + "the map with key objects, and the third to populate the map with\n"
            + "value objects. The long input fed to the second and third functions\n"
            + "is incremented between entries. Regardless of the object type provided\n"
            + "by the second and third functions, {@link java.lang.Object#toString()}\n"
            + "is used to determine the key and value to add to the map.\n"
            + "\n"
            + "To create Maps of any key and value types, simply use {@link Map} with\n"
            + "an specific key and value mapping functions.\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "java.util.Map<java.lang.String,java.lang.String>";
  }

  public Category[] getCategories() {
    return new Category[] { Category.collections };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("StringMap", "", 
            new LinkedHashMap<String, String>() {{
              put("sizeFunc","java.util.function.LongToIntFunction");
              put("keyFunc","java.util.function.LongFunction<java.lang.Object>");
              put("valueFunc","java.util.function.LongFunction<java.lang.Object>");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("StringMap(HashRange(3,7),NumberNameToString(),HashRange(1300,1700))");
                add("create a map of size 3-7 entries, with a key of type string and a value of type int (Integer by autoboxing)");
              }});
            }}
          ));
          add(new DocForFuncCtor("StringMap", "", 
            new LinkedHashMap<String, String>() {{
              put("objfuncs","java.util.function.LongFunction<java.lang.Object>[]...");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("StringMap(NumberNameToString(),HashRange(1300,1700),NumberNameToString(),HashRange(3,7))");
                add("create a map of size 2, with a specific function for each key and each value");
              }});
            }}
          ));
        }};
  }
}
