// This file is auto-generated.
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_long;

import io.nosqlbench.nb.api.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class ShuffleAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "Shuffle";
  }

  public String getPackageName() {
    return "io.nosqlbench.virtdata.library.basics.shared.from_long.to_long";
  }

  public String getClassJavadoc() {
    return "This function provides a low-overhead shuffling effect without loading\n"
            + "elements into memory. It uses a bundled dataset of pre-computed\n"
            + "Galois LFSR shift register configurations, along with a down-sampling\n"
            + "method to provide amortized virtual shuffling with minimal memory usage.\n"
            + "\n"
            + "Essentially, this guarantees that every value in the specified range will\n"
            + "be seen at least once before the cycle repeats. However, since the order\n"
            + "of traversal of these values is dependent on the LFSR configuration, some\n"
            + "orders will appear much more random than others depending on where you\n"
            + "are in the traversal cycle.\n"
            + "\n"
            + "This function *does* yield values that are deterministic.\n";
  }

  public String getInType() {
    return "long";
  }

  public String getOutType() {
    return "long";
  }

  public Category[] getCategories() {
    return new Category[] {  };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("Shuffle", "", 
            new LinkedHashMap<String, String>() {{
              put("min","long");
              put("maxPlusOne","long");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("Shuffle(11,99)");
                add("Provide all values between 11 and 98 inclusive, in some order, then repeat");
              }});
            }}
          ));
          add(new DocForFuncCtor("Shuffle", "", 
            new LinkedHashMap<String, String>() {{
              put("min","long");
              put("maxPlusOne","long");
              put("bankSelector","int");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("Shuffle(11,99,3)");
                add("Provide all values between 11 and 98 inclusive, in some different (and repeatable) order, then repeat");
              }});
            }}
          ));
        }};
  }
}
