// This file is auto-generated.
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_object;

import io.nosqlbench.nb.api.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class CoinFuncAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "CoinFunc";
  }

  public String getPackageName() {
    return "io.nosqlbench.virtdata.library.basics.shared.from_long.to_object";
  }

  public String getClassJavadoc() {
    return "This is a higher-order function which takes an input value,\n"
            + "and flips a coin. The first parameter is used as the threshold\n"
            + "for choosing a function. If the sample values derived from the\n"
            + "input is lower than the threshold value, then the first following\n"
            + "function is used, and otherwise the second is used.\n"
            + "\n"
            + "For example, if the threshold is 0.23, and the input value is\n"
            + "hashed and sampled in the unit interval to 0.43, then the second\n"
            + "of the two provided functions will be used.\n"
            + "\n"
            + "The input value does not need to be hashed beforehand, since the\n"
            + "user may need to use the full input value before hashing as the\n"
            + "input to one or both of the functions.\n"
            + "\n"
            + "This function will accept either a LongFunction or a {@link Function}\n"
            + "or a LongUnaryOperator in either position. If necessary, use\n"
            + "{@link java.util.function.ToLongFunction} to adapt other function forms to be\n"
            + "compatible with these signatures.\n";
  }

  public String getInType() {
    return "java.lang.Long";
  }

  public String getOutType() {
    return "java.lang.Object";
  }

  public Category[] getCategories() {
    return new Category[] { Category.distributions };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("CoinFunc", "", 
            new LinkedHashMap<String, String>() {{
              put("threshold","double");
              put("first","java.lang.Object");
              put("second","java.lang.Object");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("CoinFunc(0.15,NumberNameToString(),Combinations('A:1:B:23'))");
                add("use the first function 15% of the time");
              }});
            }}
          ));
        }};
  }
}
