// This file is auto-generated.
package io.nosqlbench.virtdata.library.basics.shared.from_string.to_epoch;

import io.nosqlbench.nb.api.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class DateTimeParserAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "DateTimeParser";
  }

  public String getPackageName() {
    return "io.nosqlbench.virtdata.library.basics.shared.from_string.to_epoch";
  }

  public String getClassJavadoc() {
    return "This function will parse a String containing a formatted\n"
            + "date time, yielding a DateTime object.\n"
            + "\n"
            + "If no arguments are provided, then the format is set to\n"
            + "<pre>yyyy-MM-dd HH:mm:ss.SSSZ</pre>.\n"
            + "\n"
            + "For details on formatting options, see @see <a href=\"https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html\">DateTimeFormat</a>\n";
  }

  public String getInType() {
    return "java.lang.String";
  }

  public String getOutType() {
    return "org.joda.time.DateTime";
  }

  public Category[] getCategories() {
    return new Category[] { Category.datetime };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("DateTimeParser", "Initialize the parser with the default pattern of <pre>yyyy-MM-dd HH:mm:ss.SSSZ</pre>.\n", 
            new LinkedHashMap<String, String>() {{
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("DateTimeParser()");
                add("parse any date in the yyyy-MM-dd HH:mm:ss.SSSZ format");
              }});
            }}
          ));
          add(new DocForFuncCtor("DateTimeParser", "Initialize the parser with the given pattern. With this form, if any input fails to parse,\n"
              + "or is null or empty, then an exception is thrown.\n"
              + "@param dateTimePattern The pattern which represents the incoming format.\n", 
            new LinkedHashMap<String, String>() {{
              put("dateTimePattern","java.lang.String");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("DateTimeParser('yyyy-MM-dd')");
                add("parse any date in the yyyy-MM-dd format");
              }});
            }}
          ));
          add(new DocForFuncCtor("DateTimeParser", "Initialize the parser with the given pattern and default value. In this form, if any\n"
              + "input fails to parse, then exceptions are suppressed and the default is provided instead.\n"
              + "At initialization, the default is parsed as a sanity check.\n"
              + "@param dateTimePattern The pattern which represents the incoming format.\n"
              + "@param defaultTime An example of a formatted datetime string which is used as a default.\n", 
            new LinkedHashMap<String, String>() {{
              put("dateTimePattern","java.lang.String");
              put("defaultTime","java.lang.String");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("DateTimeParser('yyyy-MM-dd','1999-12-31')");
                add("parse any date in the yyyy-MM-dd format, or return the DateTime represented by 1999-12-31");
              }});
            }}
          ));
        }};
  }
}
