// This file is auto-generated.
package io.nosqlbench.virtdata.library.basics.shared.stateful;

import io.nosqlbench.nb.api.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.lang.String;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Service(DocFuncData.class)
public class LoadDoubleAutoDocsInfo implements DocFuncData {
  public String getClassName() {
    return "LoadDouble";
  }

  public String getPackageName() {
    return "io.nosqlbench.virtdata.library.basics.shared.stateful";
  }

  public String getClassJavadoc() {
    return "Load a value from a named thread-local variable, where the variable\n"
            + "name is fixed or a generated variable name from a provided function.\n"
            + "If the named variable is not defined, then the default value is returned.\n";
  }

  public String getInType() {
    return "java.lang.Object";
  }

  public String getOutType() {
    return "java.lang.Double";
  }

  public Category[] getCategories() {
    return new Category[] { Category.state };
  }

  public List<DocCtorData> getCtors() {
    return new ArrayList<DocCtorData>() {{
          add(new DocForFuncCtor("LoadDouble", "", 
            new LinkedHashMap<String, String>() {{
              put("name","java.lang.String");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("LoadDouble('foo')");
                add("for the current thread, load a double value from the named variable.");
              }});
            }}
          ));
          add(new DocForFuncCtor("LoadDouble", "", 
            new LinkedHashMap<String, String>() {{
              put("name","java.lang.String");
              put("defaultValue","double");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("LoadDouble('foo',23D)");
                add("for the current thread, load a double value from the named variable,or the default value if the named variable is not defined.");
              }});
            }}
          ));
          add(new DocForFuncCtor("LoadDouble", "", 
            new LinkedHashMap<String, String>() {{
              put("nameFunc","java.util.function.Function<java.lang.Object,java.lang.Object>");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("LoadDouble(NumberNameToString())");
                add("for the current thread, load a double value from the named variable, where the variable name is provided by a function.");
              }});
            }}
          ));
          add(new DocForFuncCtor("LoadDouble", "", 
            new LinkedHashMap<String, String>() {{
              put("nameFunc","java.util.function.Function<java.lang.Object,java.lang.Object>");
              put("defaultValue","double");
            }},
            new ArrayList<List<String>>() {{
              add(new ArrayList<String>() {{
                add("LoadDouble(NumberNameToString(),23D)");
                add("for the current thread, load a double value from the named variable,where the variable name is provided by a function, or the default value if the namedvariable is not defined.");
              }});
            }}
          ));
        }};
  }
}
