/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.conversions.from_long;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.nio.ByteBuffer;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.conversion})
public class ToByteBuffer
implements LongFunction<ByteBuffer> {
    private final int allocSize;
    private final int bufSize;

    public ToByteBuffer() {
        this.allocSize = 8;
        this.bufSize = 8;
    }

    @Example(value={"ToByteBuffer(13)", "Repeat the input long value to make a 13byte buffer"})
    public ToByteBuffer(int size) {
        this.bufSize = size;
        this.allocSize = (size + 8 - 1) / 8 * 8;
    }

    @Override
    public ByteBuffer apply(long input) {
        ByteBuffer buffer = ByteBuffer.allocate(this.allocSize);
        while (buffer.remaining() >= 8) {
            buffer.putLong(input);
        }
        buffer.position(this.bufSize);
        buffer.flip();
        return buffer;
    }
}

