/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.conversions.from_long;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.function.LongToIntFunction;

@ThreadSafeMapper
@Categories(value={Category.conversion})
public class ToInt
implements LongToIntFunction {
    private final int scale;

    @Example(value={"ToInt(1000)", "converts a long input value to an int between 0 and 999, inclusive"})
    public ToInt(int scale) {
        this.scale = scale;
    }

    @Example(value={"ToInt()", "converts a long input value to an int between 0 and 2147483647, inclusive "})
    public ToInt() {
        this.scale = Integer.MAX_VALUE;
    }

    @Override
    public int applyAsInt(long input) {
        return (int)(input % (long)this.scale);
    }
}

