/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.distributions;

import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.core.stathelpers.AliasSamplerDoubleInt;
import io.nosqlbench.virtdata.library.basics.core.stathelpers.EvProbD;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.LongFunction;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

@Categories(value={Category.general})
@ThreadSafeMapper
public class WeightedStringsFromCSV
implements LongFunction<String> {
    private final String[] filenames;
    private final String valueColumn;
    private final String weightColumn;
    private final String[] lines;
    private final AliasSamplerDoubleInt sampler;
    private Hash hash;

    /*
     * WARNING - void declaration
     */
    public WeightedStringsFromCSV(String valueColumn, String weightColumn, String ... filenames) {
        this.filenames = filenames;
        this.valueColumn = valueColumn;
        this.weightColumn = weightColumn;
        ArrayList<EvProbD> events = new ArrayList<EvProbD>();
        ArrayList<String> values = new ArrayList<String>();
        if (filenames[0].equals("map")) {
            filenames = Arrays.copyOfRange(filenames, 1, filenames.length);
            this.hash = null;
        } else {
            if (filenames[0].equals("hash")) {
                filenames = Arrays.copyOfRange(filenames, 1, filenames.length);
            }
            this.hash = new Hash();
        }
        for (String string : filenames) {
            void var9_9;
            if (!string.endsWith(".csv")) {
                String string2 = string + ".csv";
            }
            CSVParser csvdata = NBIO.readFileCSV((String)var9_9, (String[])new String[0]);
            for (CSVRecord csvdatum : csvdata) {
                if (csvdatum.get(valueColumn) == null || csvdatum.get(weightColumn) == null) continue;
                String value = csvdatum.get(valueColumn);
                values.add(value);
                String weight = csvdatum.get(weightColumn);
                if (weight.isEmpty()) continue;
                events.add(new EvProbD(values.size() - 1, Double.valueOf(weight)));
            }
        }
        this.sampler = new AliasSamplerDoubleInt(events);
        this.lines = values.toArray(new String[0]);
    }

    @Override
    public String apply(long value) {
        if (this.hash != null) {
            value = this.hash.applyAsLong(value);
        }
        double unitValue = (double)value / 9.223372036854776E18;
        int idx = this.sampler.applyAsInt(unitValue);
        return this.lines[idx];
    }
}

