/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_double.to_bigdecimal;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.Examples;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.util.MathContextReader;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.function.DoubleFunction;

@ThreadSafeMapper
@Categories(value={Category.conversion})
public class ToBigDecimal
implements DoubleFunction<BigDecimal> {
    private final MathContext mathContext;

    @Example(value={"ToBigDecimal()", "Convert all double values to BigDecimal values with no limits (using MathContext.UNLIMITED)"})
    public ToBigDecimal() {
        this.mathContext = MathContext.UNLIMITED;
    }

    @Examples(value={@Example(value={"ToBigDecimal('DECIMAL32')", "IEEE 754R Decimal32 format, 7 digits, HALF_EVEN"}), @Example(value={"ToBigDecimal('DECIMAL64'),", "IEEE 754R Decimal64 format, 16 digits, HALF_EVEN"}), @Example(value={"ToBigDecimal('DECIMAL128')", "IEEE 754R Decimal128 format, 34 digits, HALF_EVEN"}), @Example(value={"ToBigDecimal('UNLIMITED')", "unlimited precision, HALF_UP"}), @Example(value={"ToBigDecimal('precision=17 roundingMode=UNNECESSARY')", "Custom precision with no rounding performed"})})
    public ToBigDecimal(String context) {
        this.mathContext = MathContextReader.getMathContext(context);
    }

    @Override
    public BigDecimal apply(double value) {
        return new BigDecimal(value, this.mathContext);
    }
}

