/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_bytebuffer;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import java.nio.ByteBuffer;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.general})
public class HashedToByteBuffer
implements LongFunction<ByteBuffer> {
    private final Hash hash;
    private final int length;
    private final int bytes;
    private final int longs;

    public HashedToByteBuffer(int lengthInBytes) {
        this.length = lengthInBytes;
        this.hash = new Hash();
        this.longs = this.length / 8 + 1;
        this.bytes = this.longs * 8;
    }

    @Override
    public ByteBuffer apply(long input) {
        ByteBuffer buffer = ByteBuffer.allocate(this.bytes);
        for (int i = 0; i < this.longs; ++i) {
            long l = this.hash.applyAsLong(input + (long)i);
            buffer.putLong(l);
        }
        buffer.flip();
        buffer.limit(this.length);
        return buffer;
    }
}

