/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class ListFunctions
implements LongFunction<List<Object>> {
    private final List<LongFunction> valueFuncs;
    private final int size;

    @Example(value={"ListFunctions(NumberNameToString(),NumberNameToString(),NumberNameToString())", "Create a list of object values of each function output. Produces values like ['one','one','one']"})
    public ListFunctions(Object ... funcs) {
        this.valueFuncs = VirtDataConversions.adaptFunctionList((Object[])funcs, LongFunction.class, (Class[])new Class[]{Object.class});
        this.size = this.valueFuncs.size();
    }

    @Override
    public List<Object> apply(long value) {
        ArrayList<Object> list = new ArrayList<Object>(this.size);
        for (int i = 0; i < this.size; ++i) {
            list.add(this.valueFuncs.get(i).apply(value));
        }
        return list;
    }
}

