/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.LongFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class SetHashed
implements LongFunction<Set<Object>> {
    private final List<LongFunction> valueFuncs;
    private final int size;
    private final Hash hasher = new Hash();

    @Example(value={"SetHashed(ToString(), WeightedStrings('text:1'))", "Create a hash list of object values of each function output, like ['2945182322382062539','text']"})
    public SetHashed(Object ... funcs) {
        this.valueFuncs = VirtDataConversions.adaptFunctionList((Object[])funcs, LongFunction.class, (Class[])new Class[]{Object.class});
        this.size = this.valueFuncs.size();
    }

    @Override
    public Set<Object> apply(long value) {
        long hash = value;
        HashSet<Object> list = new HashSet<Object>(this.size);
        for (int i = 0; i < this.size; ++i) {
            hash = this.hasher.applyAsLong(hash);
            int selector = Math.min(i, this.valueFuncs.size() - 1);
            LongFunction func = this.valueFuncs.get(selector);
            list.add(func.apply(hash));
        }
        return list;
    }
}

