/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_collection;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;

@Categories(value={Category.collections})
@ThreadSafeMapper
public class SetSizedStepped
implements LongFunction<Set<Object>> {
    private final List<LongFunction> valueFuncs;
    private final LongToIntFunction sizeFunc;

    @Example(value={"SetSizedStepped(Mod(3),NumberNameToString(),NumberNameToString())", "Create a set, like ['three','four']"})
    public SetSizedStepped(Object sizeFunc, Object ... funcs) {
        if (sizeFunc instanceof Number) {
            int size = ((Number)sizeFunc).intValue();
            this.sizeFunc = s -> size;
        } else {
            this.sizeFunc = (LongToIntFunction)VirtDataConversions.adaptFunction((Object)sizeFunc, LongToIntFunction.class, (Class[])new Class[0]);
        }
        this.valueFuncs = VirtDataConversions.adaptFunctionList((Object[])funcs, LongFunction.class, (Class[])new Class[]{Object.class});
    }

    public SetSizedStepped(int size, Object ... funcs) {
        this.sizeFunc = s -> size;
        this.valueFuncs = VirtDataConversions.adaptFunctionList((Object[])funcs, LongFunction.class, (Class[])new Class[]{Object.class});
    }

    @Override
    public Set<Object> apply(long value) {
        int size = this.sizeFunc.applyAsInt(value);
        HashSet<Object> list = new HashSet<Object>(size);
        for (int i = 0; i < size; ++i) {
            int selector = Math.min(i, this.valueFuncs.size() - 1);
            LongFunction func = this.valueFuncs.get(selector);
            list.add(func.apply((long)i + value));
        }
        return list;
    }
}

