/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_long;

import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.Hash;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
public class HashInterval
implements LongUnaryOperator {
    private final long minValue;
    private final long width;
    private final Hash hash = new Hash();

    @Example(value={"HashInterval(4L)", "return values which could include 0L, 1L, 2L, 3L, but not 4L"})
    public HashInterval(long width) {
        this.minValue = 0L;
        this.width = width;
    }

    @Example(value={"HashInterval(2L,5L)", "return values which could include 2L, 3L, 4L, but not 5L"})
    public HashInterval(long minIncl, long maxExcl) {
        if (maxExcl <= minIncl) {
            throw new BasicError("HashInterval must have min and max value in that order, where the min is less than the max.");
        }
        this.minValue = minIncl;
        this.width = maxExcl - minIncl;
    }

    @Override
    public long applyAsLong(long operand) {
        return this.minValue + this.hash.applyAsLong(operand) % this.width;
    }
}

