/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_long;

import io.nosqlbench.nb.annotations.Service;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.processors.DocCtorData;
import io.nosqlbench.virtdata.api.processors.DocForFuncCtor;
import io.nosqlbench.virtdata.api.processors.DocFuncData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(value=DocFuncData.class, selector="io.nosqlbench.virtdata.library.basics.shared.from_long.to_long.HashInterval")
public class HashIntervalAutoDocsInfo
implements DocFuncData {
    public String getClassName() {
        return "HashInterval";
    }

    public String getPackageName() {
        return "io.nosqlbench.virtdata.library.basics.shared.from_long.to_long";
    }

    public String getClassJavadoc() {
        return "Return a value within a range, pseudo-randomly, using interval semantics,\nwhere the range of values return does not include the last value.\nThis function behaves exactly like HashRange except for the exclusion\nof the last value. This allows you to stack intervals using known\nreference points without duplicating or skipping any given value.\n\nYou can specify hash intervals as small as a single-element range, like\n(5,6), or as wide as the relevant data type allows.\n";
    }

    public String getInType() {
        return "long";
    }

    public String getOutType() {
        return "long";
    }

    public Category[] getCategories() {
        return new Category[0];
    }

    public List<DocCtorData> getCtors() {
        return new ArrayList<DocCtorData>(){
            {
                this.add(new DocForFuncCtor("HashInterval", "Create a hash interval based on a minimum value of 0 and a specified width.\n@param width The maximum value, which is excluded.\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("width", "long");
                    }
                }, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("HashInterval(4L)");
                                this.add("return values which could include 0L, 1L, 2L, 3L, but not 4L");
                            }
                        });
                    }
                }));
                this.add(new DocForFuncCtor("HashInterval", "Create a hash interval\n@param minIncl The minimum value, which is included\n@param maxExcl The maximum value, which is excluded\n", (Map)new LinkedHashMap<String, String>(){
                    {
                        this.put("minIncl", "long");
                        this.put("maxExcl", "long");
                    }
                }, (List)new ArrayList<List<String>>(){
                    {
                        this.add(new ArrayList<String>(){
                            {
                                this.add("HashInterval(2L,5L)");
                                this.add("return values which could include 2L, 3L, 4L, but not 5L");
                            }
                        });
                    }
                }));
            }
        };
    }
}

