/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_long;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.function.LongUnaryOperator;

@ThreadSafeMapper
@Categories(value={Category.general})
public class PartitionLongs
implements LongUnaryOperator {
    private final int partitions;
    private final long[] starts;

    public PartitionLongs(int partitions) {
        this.partitions = partitions;
        if (partitions < 1) {
            throw new RuntimeException("partitions must be at least 1");
        }
        if (partitions == 1) {
            this.starts = new long[]{Long.MIN_VALUE};
        } else {
            this.starts = new long[partitions];
            long half_interval = Long.MIN_VALUE / (long)partitions;
            for (int i = 0; i < this.starts.length; ++i) {
                this.starts[i] = Long.MIN_VALUE + ((long)i * half_interval + (long)i * half_interval);
            }
        }
    }

    @Override
    public long applyAsLong(long operand) {
        int idx = (int)(operand % (long)this.starts.length);
        return this.starts[idx];
    }
}

