/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_string;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.Examples;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.util.CharsetMapping;
import java.nio.CharBuffer;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.general})
public class Combinations
implements LongFunction<String> {
    private final char[][] charsets;
    private final long[] modulo;

    @Examples(value={@Example(value={"Combinations('A-Z;A-Z')", "a two digit alphanumeric code. Wraps at 26^2"}), @Example(value={"Combinations('0-9A-F')", "a single hexadecimal digit"}), @Example(value={"Combinations('0123456789ABCDEF')", "a single hexadecimal digit"}), @Example(value={"Combinations('0-9A-F;0-9A-F;0-9A-F;0-9A-F;')", "two bytes of hexadecimal"}), @Example(value={"Combinations('A-9')", "upper case alphanumeric"})})
    public Combinations(String spec) {
        this.charsets = CharsetMapping.parseSpec(spec);
        this.modulo = this.computeRadixFactors(this.charsets);
    }

    @Override
    public String apply(long value) {
        CharBuffer cb = CharBuffer.allocate(this.charsets.length);
        for (int cs = 0; cs < this.charsets.length; ++cs) {
            int charv = (int)(value / this.modulo[cs] % Integer.MAX_VALUE);
            value %= this.modulo[cs];
            int selector = charv % this.charsets[cs].length;
            char c = this.charsets[cs][selector];
            cb.put(cs, c);
        }
        return cb.toString();
    }

    private long[] computeRadixFactors(char[][] charsets) {
        long modulo = 1L;
        long[] m = new long[charsets.length];
        for (int i = charsets.length - 1; i >= 0; --i) {
            m[i] = modulo;
            modulo = Math.multiplyExact(modulo, charsets[i].length);
        }
        return m;
    }
}

