/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_long.to_string;

import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataConversions;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_int.HashRange;
import java.nio.CharBuffer;
import java.util.function.LongFunction;
import java.util.function.LongToIntFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ThreadSafeMapper
@Categories(value={Category.general})
public class HashedFileExtractToString
implements LongFunction<String> {
    private static final Logger logger = LogManager.getLogger(HashedFileExtractToString.class);
    private final CharBuffer buf;
    private final LongToIntFunction sizeFunc;
    private final LongToIntFunction positionRange = new HashRange(0, Integer.MAX_VALUE);
    private static final ThreadLocal<StringBuilder> tl_sb = ThreadLocal.withInitial(StringBuilder::new);
    private final String filename;

    @Example(value={"HashedFileExtractToString('data/adventures.txt',100,200)", "return a fragment from adventures.txt between 100 and 200 characters long"})
    public HashedFileExtractToString(String filename, int minsize, int maxsize) {
        this.filename = filename;
        this.buf = NBIO.readCharBuffer((String)filename, (String[])new String[0]).asReadOnlyBuffer();
        this.sizeFunc = new HashRange(minsize, maxsize);
    }

    @Example(value={"HashedFileExtractToString('data/adventures.txt',Uniform())", "return a fragment from adventures.txt from a random offset, based on the size function provided."})
    public HashedFileExtractToString(String filename, Object sizefunc) {
        this.filename = filename;
        this.buf = NBIO.readCharBuffer((String)filename, (String[])new String[0]).asReadOnlyBuffer();
        this.sizeFunc = (LongToIntFunction)VirtDataConversions.adaptFunction((Object)sizefunc, LongToIntFunction.class, (Class[])new Class[0]);
    }

    @Override
    public String apply(long input) {
        int size = this.sizeFunc.applyAsInt(input) % this.buf.limit();
        int pos = this.positionRange.applyAsInt(input);
        return this.buf.subSequence(pos %= this.buf.limit() - size, pos + size).toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }
}

