/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_string;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.Examples;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VirtDataFunctions;
import io.nosqlbench.virtdata.core.composers.FunctionAssembly;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafeMapper
@Categories(value={Category.general})
public class MatchFunc
implements Function<String, String> {
    private final MatchEntry[] entries;
    private static final Function<String, String> PASSTHRU = s -> s;

    @Examples(value={@Example(value={"MatchFunc('.*','onevalue')", "Match all String inputs, simply returning 'onevalue' as the output value."}), @Example(value={"MatchFunc('[0-9]+',Suffix('-is-a-number'))", "Append '-is-a-number' to every input which is a sequence of digits"})})
    public MatchFunc(Object ... funcs) {
        if (funcs.length % 2 != 0) {
            throw new RuntimeException("You must provide 'pattern1',func1,... for an even number of arguments.");
        }
        FunctionAssembly assembly = new FunctionAssembly();
        this.entries = new MatchEntry[funcs.length / 2];
        for (int i = 0; i < funcs.length; i += 2) {
            Pattern pattern = Pattern.compile(funcs[i].toString());
            Object funcObject = funcs[i + 1];
            Function function = funcObject instanceof String ? s -> funcObject.toString() : (funcObject instanceof Function ? (Function)funcObject : (Function)VirtDataFunctions.adapt((Object)funcObject, Function.class, String.class, (boolean)true));
            this.entries[i / 2] = new MatchEntry(pattern, function);
        }
    }

    @Override
    public String apply(String s) {
        for (MatchEntry entry : this.entries) {
            Matcher m = entry.tryMatch(s);
            if (m == null) continue;
            String result = entry.f.apply(s);
            return result;
        }
        return s;
    }

    private static class MatchEntry {
        public final Pattern pattern;
        public final Function<String, String> f;

        public MatchEntry(Pattern pattern, Function f) {
            this.pattern = pattern;
            this.f = f;
        }

        public Matcher tryMatch(String s) {
            Matcher matcher = this.pattern.matcher(s);
            if (matcher.matches()) {
                return matcher;
            }
            return null;
        }
    }
}

