/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.from_string.to_bigdecimal;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.shared.util.MathContextReader;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.function.Function;

@ThreadSafeMapper
@Categories(value={Category.conversion})
public class ToBigDecimal
implements Function<String, BigDecimal> {
    private final MathContext context;

    @Example(value={"Convert strings to BigDecimal according to default precision (unlimited) and rounding (HALF_UP)"})
    public ToBigDecimal() {
        this.context = MathContext.UNLIMITED;
    }

    public ToBigDecimal(String context) {
        this.context = MathContextReader.getMathContext(context);
    }

    @Override
    public BigDecimal apply(String s) {
        return new BigDecimal(s, this.context);
    }
}

