/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.nondeterministic.to_long;

import io.nosqlbench.nb.api.metadata.Indexed;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.function.LongUnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafeMapper
@Categories(value={Category.state})
public class ThreadNum
implements LongUnaryOperator {
    private static final Pattern pattern = Pattern.compile("^.*?(\\d+).*$");
    private final ThreadLocal<Long> threadLocalInt = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            if (Thread.currentThread() instanceof Indexed) {
                return ((Indexed)Thread.currentThread()).getIndex();
            }
            Matcher matcher = pattern.matcher(Thread.currentThread().getName());
            if (matcher.matches()) {
                return Long.valueOf(matcher.group(1));
            }
            throw new RuntimeException("Unable to match a digit sequence in thread name:" + Thread.currentThread().getName());
        }
    };

    @Override
    public long applyAsLong(long input) {
        return this.threadLocalInt.get();
    }
}

