/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.stateful;

import io.nosqlbench.nb.api.config.standard.ConfigModel;
import io.nosqlbench.nb.api.config.standard.NBConfigModel;
import io.nosqlbench.nb.api.config.standard.NBMapConfigurable;
import io.nosqlbench.nb.api.config.standard.Param;
import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.Map;
import java.util.function.Function;

@ThreadSafeMapper
@Categories(value={Category.general})
public class LoadElement
implements Function<Object, Object>,
NBMapConfigurable {
    private final String varname;
    private final Object defaultValue;
    private final String mapname;
    private Map<String, ?> vars;

    @Example(value={"LoadElement('varname','vars','defaultvalue')", "Load the varable 'varname' from a map named 'vars', or provide 'defaultvalue' if neither is provided"})
    public LoadElement(String varname, String mapname, Object defaultValue) {
        this.mapname = mapname;
        this.varname = varname;
        this.defaultValue = defaultValue;
    }

    @Override
    public Object apply(Object o) {
        if (this.vars == null) {
            return this.defaultValue;
        }
        Object object = this.vars.get(this.varname);
        return object != null ? object : this.defaultValue;
    }

    public void applyConfig(Map<String, ?> providedConfig) {
        Map vars = (Map)providedConfig.get(this.mapname);
        if (vars != null) {
            this.vars = vars;
        }
    }

    public NBConfigModel getConfigModel() {
        return ConfigModel.of(this.getClass(), (Param[])new Param[]{Param.optional((String)"<mapname>", Map.class)});
    }
}

