/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.stateful;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;

@Categories(value={Category.state})
@ThreadSafeMapper
public class SaveString
implements Function<String, String> {
    private final String name;
    private final Function<Object, Object> nameFunc;

    @Example(value={"SaveString('foo')", "save the current String value to a named variable in this thread."})
    public SaveString(String name) {
        this.name = name;
        this.nameFunc = null;
    }

    @Example(value={"SaveString(NumberNameToString())", "save the current String value to a named variable in this thread, where the variable name is provided by a function."})
    public SaveString(Function<Object, Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
    }

    @Override
    public String apply(String s) {
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(s)) : this.name;
        map.put(varname, s);
        return s;
    }
}

