/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.stateful;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.api.bindings.VALUE;
import io.nosqlbench.virtdata.library.basics.shared.from_long.to_double.HashedDoubleRange;
import io.nosqlbench.virtdata.library.basics.shared.stateful.Load;
import java.util.function.LongFunction;

@ThreadSafeMapper
@Categories(value={Category.state, Category.nulls})
public class UnsetOrLoad
implements LongFunction<Object> {
    private final String varname;
    private double ratio;
    private final HashedDoubleRange rangefunc = new HashedDoubleRange(0.0, 1.0);
    private final Load load;

    public UnsetOrLoad(double ratio, String varname) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new RuntimeException("The " + UnsetOrLoad.class.getSimpleName() + " function requires a ratio between 0.0D and 1.0D");
        }
        this.ratio = ratio;
        this.load = new Load(varname);
        this.varname = varname;
    }

    @Override
    public Object apply(long basis) {
        double v = this.rangefunc.applyAsDouble(basis);
        if (v <= this.ratio) {
            return VALUE.unset;
        }
        return this.load.apply((Object)basis);
    }
}

