/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.unary_int;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.murmur.Murmur3F;
import java.nio.ByteBuffer;
import java.util.function.IntUnaryOperator;

@ThreadSafeMapper
@Categories(value={Category.general})
public class Hash
implements IntUnaryOperator {
    private final ThreadLocal<Murmur3F> murmur3f_TL = ThreadLocal.withInitial(Murmur3F::new);

    @Override
    public int applyAsInt(int operand) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        Murmur3F murmur3f = this.murmur3f_TL.get();
        murmur3f.reset();
        bb.putInt(0, operand);
        bb.putInt(4, operand);
        bb.position(0);
        murmur3f.update(bb.array());
        long result = Math.abs(murmur3f.getValue());
        return (int)result & Integer.MAX_VALUE;
    }
}

