/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.unary_int;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.library.basics.core.threadstate.SharedState;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;

@Categories(value={Category.state})
@ThreadSafeMapper
public class Load
implements IntUnaryOperator {
    private final String name;
    private final Function<Object, Object> nameFunc;
    private final int defaultValue;

    @Example(value={"Load('foo')", "for the current thread, load an int value from the named variable"})
    public Load(String name) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = 0;
    }

    @Example(value={"Load('foo',42)", "for the current thread, load an int value from the named variable, or return the default value if it is undefined."})
    public Load(String name, int defaultValue) {
        this.name = name;
        this.nameFunc = null;
        this.defaultValue = defaultValue;
    }

    @Example(value={"Load(NumberNameToString())", "for the current thread, load an int value from the named variable, where the variable name is provided by a function."})
    public Load(Function<Object, Object> nameFunc) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = 0;
    }

    @Example(value={"Load(NumberNameToString(),42)", "for the current thread, load an int value from the named variable, where the variable name is provided by a function, or the default value if the named variable is undefined."})
    public Load(Function<Object, Object> nameFunc, int defaultValue) {
        this.name = null;
        this.nameFunc = nameFunc;
        this.defaultValue = defaultValue;
    }

    @Override
    public int applyAsInt(int operand) {
        HashMap<String, Object> map = SharedState.tl_ObjectMap.get();
        String varname = this.nameFunc != null ? String.valueOf(this.nameFunc.apply(operand)) : this.name;
        Object o = map.getOrDefault(varname, this.defaultValue);
        return (Integer)o;
    }
}

