/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.unary_string;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ThreadSafeMapper
@Categories(value={Category.general})
public class ReplaceRegex
implements Function<String, String> {
    private final String replacement;
    private final Pattern pattern;

    @Example(value={"ReplaceRegex('[one]','two')", "Replace all occurrences of 'o' or 'n' or 'e' with 'two'"})
    public ReplaceRegex(String regex, String replacement) {
        this.pattern = Pattern.compile(regex);
        this.replacement = replacement;
    }

    @Override
    public String apply(String s) {
        Matcher matcher = this.pattern.matcher(s);
        StringBuilder sb = new StringBuilder(s.length());
        while (matcher.find()) {
            matcher.appendReplacement(sb, this.replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

