/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.basics.shared.unary_string;

import io.nosqlbench.virtdata.api.annotations.Categories;
import io.nosqlbench.virtdata.api.annotations.Category;
import io.nosqlbench.virtdata.api.annotations.Example;
import io.nosqlbench.virtdata.api.annotations.ThreadSafeMapper;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;

@ThreadSafeMapper
@Categories(value={Category.conversion})
public class URLDecode
implements Function<String, String> {
    private final Charset charset;

    @Example(value={"URLDecode('UTF-16')", "URLDecode using the UTF-16 charset."})
    public URLDecode(String charset) {
        this.charset = Charset.forName(charset);
    }

    @Example(value={"URLDecode()", "URLDecode using the default UTF-8 charset."})
    public URLDecode() {
        this.charset = StandardCharsets.UTF_8;
    }

    @Override
    public String apply(String s) {
        return URLDecoder.decode(s, this.charset);
    }
}

