/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.api;

import io.nosqlbench.virtdata.api.BindingsTemplate;
import io.nosqlbench.virtdata.api.DataMapper;
import io.nosqlbench.virtdata.api.LazyValuesMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Bindings {
    private static final Logger logger = LogManager.getLogger(Bindings.class);
    private BindingsTemplate template;
    private List<DataMapper<?>> dataMappers = new ArrayList();
    private ThreadLocal<Map<String, DataMapper<?>>> nameCache;

    public Bindings(final BindingsTemplate template, final List<DataMapper<?>> dataMappers) {
        this.template = template;
        this.dataMappers = dataMappers;
        this.nameCache = ThreadLocal.withInitial(() -> new HashMap<String, DataMapper<?>>(){
            {
                for (int i = 0; i < template.getBindPointNames().size(); ++i) {
                    this.put(template.getBindPointNames().get(i), (DataMapper)dataMappers.get(i));
                }
            }
        });
    }

    public String toString() {
        return this.template.toString() + this.dataMappers;
    }

    public Object[] getAll(long input) {
        Object[] values = new Object[this.dataMappers.size()];
        int offset = 0;
        for (DataMapper<?> dataMapper : this.dataMappers) {
            values[offset++] = dataMapper.get(input);
        }
        return values;
    }

    public BindingsTemplate getTemplate() {
        return this.template;
    }

    public Map<String, Object> getAllMap(long input) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        this.setMap(values, input);
        return values;
    }

    public List<Map<String, Object>> getIteratedMaps(long input, int count) {
        ArrayList<Map<String, Object>> listOfMaps = new ArrayList<Map<String, Object>>(count);
        for (int i = 0; i < count; ++i) {
            HashMap<String, Object> suffixedMap = new HashMap<String, Object>();
            this.setMap(suffixedMap, input + (long)i);
            listOfMaps.add(suffixedMap);
        }
        return listOfMaps;
    }

    public Map<String, Object> getIteratedSuffixMap(long input, int count) {
        LinkedHashMap<String, Object> suffixedMap = new LinkedHashMap<String, Object>(count * this.dataMappers.size());
        this.setIteratedSuffixMap(suffixedMap, input, count);
        return suffixedMap;
    }

    public Map<String, Object> getIteratedSuffixMap(long input, int count, String ... fieldNames) {
        LinkedHashMap<String, Object> suffixedMap = new LinkedHashMap<String, Object>(count * fieldNames.length);
        this.setIteratedSuffixMap(suffixedMap, input, count, fieldNames);
        return suffixedMap;
    }

    private void setIteratedSuffixMap(Map<String, Object> suffixedMap, long input, int count, String[] fieldNames) {
        for (int i = 0; i < count; ++i) {
            for (String f : fieldNames) {
                suffixedMap.put(f + i, this.get(f, input + (long)i));
            }
        }
    }

    public Object get(int i, long input) {
        return this.dataMappers.get(i).get(input);
    }

    public Object get(String name, long input) {
        DataMapper<?> dataMapper = this.nameCache.get().get(name);
        return dataMapper.get(input);
    }

    public void setMap(Map<String, Object> donorMap, long cycle) {
        Object[] all = this.getAll(cycle);
        for (int i = 0; i < all.length; ++i) {
            donorMap.put(this.template.getBindPointNames().get(i), all[i]);
        }
    }

    public void setSuffixedMap(Map<String, Object> donorMap, long cycle, String suffix) {
        Object[] all = this.getAll(cycle);
        for (int i = 0; i < all.length; ++i) {
            donorMap.put(this.template.getBindPointNames().get(i) + suffix, all[i]);
        }
    }

    public void setIteratedSuffixMap(Map<String, Object> donorMap, long input, long count) {
        int i = 0;
        while ((long)i < count) {
            this.setSuffixedMap(donorMap, input + (long)i, String.valueOf(i));
            ++i;
        }
    }

    public void updateMap(Map<String, Object> donorMap, long input) {
        for (String s : donorMap.keySet()) {
            donorMap.put(s, this.get(s, input));
        }
    }

    public void setNamedFields(FieldSetter fieldSetter, long input, String ... fieldName) {
        for (String s : fieldName) {
            fieldSetter.setField(s, this.get(s, input));
        }
    }

    public void setNamedFieldsIterated(FieldSetter fieldSetter, long input, int count, String ... fieldName) {
        for (int i = 0; i < count; ++i) {
            for (String s : fieldName) {
                fieldSetter.setField(s + i, this.get(s, input + (long)i));
            }
        }
    }

    public void setAllFields(FieldSetter fieldSetter, long input) {
        Object[] all = this.getAll(input);
        for (int i = 0; i < all.length; ++i) {
            fieldSetter.setField(this.template.getBindPointNames().get(i), all[i]);
        }
    }

    public void setAllFieldsIterated(FieldSetter fieldSetter, long input, int count) {
        for (int i = 0; i < count; ++i) {
            Object[] all = this.getAll(input + (long)i);
            for (int j = 0; j < all.length; ++j) {
                fieldSetter.setField(this.template.getBindPointNames().get(i) + i, all[i]);
            }
        }
    }

    public LazyValuesMap getLazyMap(long input) {
        return new LazyValuesMap(this, input);
    }

    public static interface FieldSetter {
        public void setField(String var1, Object var2);
    }
}

