/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.api;

import io.nosqlbench.virtdata.api.Binder;
import io.nosqlbench.virtdata.api.Bindings;
import io.nosqlbench.virtdata.api.ValuesBinder;

public class ContextualBindings<C, R>
implements Binder<R> {
    private final C context;
    private Bindings bindings;
    private ValuesBinder<C, R> valuesBinder;

    public ContextualBindings(Bindings bindings, C context, ValuesBinder<C, R> valuesBinder) {
        this.bindings = bindings;
        this.context = context;
        this.valuesBinder = valuesBinder;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public C getContext() {
        return this.context;
    }

    @Override
    public R bind(long value) {
        Object[] allGeneratedValues = this.bindings.getAll(value);
        try {
            return this.valuesBinder.bindValues(this.context, this.bindings, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Binding error:" + this.bindings.getTemplate().toString(allGeneratedValues), e);
        }
    }
}

