/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.api;

import io.nosqlbench.virtdata.api.DataMapper;
import io.nosqlbench.virtdata.api.DataMapperFunctionMapper;
import io.nosqlbench.virtdata.api.ResolvedFunction;
import java.util.List;
import java.util.Optional;

public interface DataMapperLibrary {
    public String getLibraryName();

    default public <T> Optional<DataMapper<T>> getDataMapper(String spec) {
        if (this.canParseSpec(spec)) {
            Optional<ResolvedFunction> resolvedFunction = this.resolveFunction(spec);
            return resolvedFunction.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        }
        return Optional.empty();
    }

    default public <T> Optional<DataMapper<T>> getOptionalDataMapper(String spec, Class<? extends T> clazz) {
        return Optional.ofNullable(this.getDataMapper(spec, clazz));
    }

    default public <T> DataMapper<T> getDataMapper(String spec, Class<? extends T> clazz) {
        if (!this.canParseSpec(spec)) {
            return null;
        }
        Optional<ResolvedFunction> resolvedFunction = this.resolveFunction(spec);
        if (!resolvedFunction.isPresent()) {
            return null;
        }
        ResolvedFunction rf = resolvedFunction.get();
        DataMapper dm = DataMapperFunctionMapper.map(rf.getFunctionObject());
        return dm;
    }

    public boolean canParseSpec(String var1);

    public Optional<ResolvedFunction> resolveFunction(String var1);

    public List<ResolvedFunction> resolveFunctions(String var1);

    public List<String> getDataMapperNames();

    default public Optional<DataMapper<Long>> getLongDataMapper(String spec) {
        if (!this.canParseSpec(spec)) {
            return Optional.empty();
        }
        Optional<ResolvedFunction> resolvedFunction = this.resolveFunction(spec);
        Optional<DataMapper<Long>> mapper = resolvedFunction.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        return mapper;
    }

    default public Optional<DataMapper<Double>> getDoubleDataMapper(String spec) {
        if (!this.canParseSpec(spec)) {
            return Optional.empty();
        }
        Optional<ResolvedFunction> resolvedFunction = this.resolveFunction(spec);
        Optional<DataMapper<Double>> mapper = resolvedFunction.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        return mapper;
    }

    default public Optional<DataMapper<Integer>> getIntegerDataMapper(String spec) {
        if (!this.canParseSpec(spec)) {
            return Optional.empty();
        }
        Optional<ResolvedFunction> resolvedFunction = this.resolveFunction(spec);
        Optional<DataMapper<Integer>> mapper = resolvedFunction.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        return mapper;
    }

    default public Optional<DataMapper<String>> getStringDataMapper(String spec) {
        if (!this.canParseSpec(spec)) {
            return Optional.empty();
        }
        Optional<ResolvedFunction> resolvedFunction = this.resolveFunction(spec);
        Optional<DataMapper<String>> mapper = resolvedFunction.map(ResolvedFunction::getFunctionObject).map(DataMapperFunctionMapper::map);
        return mapper;
    }
}

