/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.api;

import io.nosqlbench.virtdata.api.Bindings;
import io.nosqlbench.virtdata.api.BindingsCache;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LazyValuesMap
implements Map<String, Object> {
    private final Bindings bindings;
    private final BindingsCache bindingsCache;
    private final long input;

    public LazyValuesMap(Bindings bindings, long input) {
        this.bindings = bindings;
        this.bindingsCache = new BindingsCache(bindings);
        this.input = input;
    }

    @Override
    public int size() {
        return this.bindings.getTemplate().getBindPointNames().size();
    }

    @Override
    public boolean isEmpty() {
        return this.bindings.getTemplate().getBindPointNames().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.bindings.getTemplate().getBindPointNames().contains((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.bindings.getTemplate().getDataMapperSpecs().contains((String)value);
    }

    @Override
    public Object get(Object key) {
        return this.bindingsCache.getField((String)key, this.input);
    }

    @Override
    public Object put(String key, Object value) {
        return this.bindingsCache.getCachedMap().put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.bindingsCache.getCachedMap().remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.bindingsCache.getCachedMap().putAll(m);
    }

    @Override
    public void clear() {
        this.bindingsCache.getCachedMap().clear();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(new HashSet<String>(){
            {
                this.addAll(LazyValuesMap.this.bindings.getTemplate().getBindPointNames());
            }
        });
    }

    @Override
    public Collection<Object> values() {
        return this.bindingsCache.getCachedMap().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.bindingsCache.getCachedMap().entrySet();
    }
}

