/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.api;

import java.math.BigDecimal;
import java.math.BigInteger;

public class StringObjectPromoter {
    public static Object promote(String raw, Class<?> targetType) {
        try {
            if (targetType == String.class) {
                return raw.matches("^'.+'$") ? raw.substring(1, raw.length() - 1) : raw;
            }
            if (targetType == Double.class || targetType == Double.TYPE) {
                Double val = Double.valueOf(raw);
                return targetType.isPrimitive() ? val.doubleValue() : val.doubleValue();
            }
            if (targetType == Float.class || targetType == Float.TYPE) {
                Float val = Float.valueOf(raw);
                return Float.valueOf(targetType.isPrimitive() ? val.floatValue() : val.floatValue());
            }
            if (targetType == Long.class || targetType == Long.TYPE) {
                Long val = Long.valueOf(raw);
                return targetType.isPrimitive() ? val.longValue() : val.longValue();
            }
            if (targetType == Integer.class || targetType == Integer.TYPE) {
                Integer val = Integer.valueOf(raw);
                return targetType.isPrimitive() ? val.intValue() : val.intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return raw;
    }

    public static Object promote(String stringArg) {
        if (stringArg.matches("^'.*'$")) {
            return stringArg.substring(1, stringArg.length() - 1);
        }
        if (stringArg.matches("^\\d+\\.\\d+(E\\d+)?[dD]$")) {
            try {
                Double doubleValue = Double.valueOf(stringArg);
                return doubleValue;
            }
            catch (NumberFormatException doubleValue) {}
        } else if (stringArg.matches("^\\d+\\.\\d+(E\\d+)?[fF]$")) {
            try {
                Float floatValue = Float.valueOf(stringArg.substring(0, stringArg.length() - 1));
                return floatValue;
            }
            catch (NumberFormatException floatValue) {}
        } else if (stringArg.matches("^\\d+\\.\\d+(E\\d+)?$")) {
            try {
                Float floatValue = Float.valueOf(stringArg);
                if (!Float.isInfinite(floatValue.floatValue())) {
                    return floatValue;
                }
            }
            catch (NumberFormatException floatValue) {
                // empty catch block
            }
            try {
                Double doubleValue = Double.valueOf(stringArg);
                if (!doubleValue.isInfinite()) {
                    return doubleValue;
                }
            }
            catch (NumberFormatException doubleValue) {
                // empty catch block
            }
            try {
                BigDecimal val = new BigDecimal(stringArg);
                return val;
            }
            catch (NumberFormatException val) {}
        } else if (stringArg.matches("^\\d+[lL]$")) {
            try {
                Long longval = Long.valueOf(stringArg.substring(0, stringArg.length() - 1));
                return longval;
            }
            catch (NumberFormatException longval) {}
        } else if (stringArg.matches("^\\d+$")) {
            try {
                Integer intValue = Integer.valueOf(stringArg);
                return intValue;
            }
            catch (NumberFormatException intValue) {
                try {
                    Long longval = Long.valueOf(stringArg);
                    return longval;
                }
                catch (NumberFormatException longval) {
                    try {
                        BigInteger val = new BigInteger(stringArg);
                        return val;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        } else if (stringArg.equals("true")) {
            return true;
        }
        return stringArg;
    }

    public static boolean isAssignableForConstructor(Class<?> have, Class<?> need) {
        if (need.isAssignableFrom(have)) {
            return true;
        }
        return need == Boolean.TYPE && have == Boolean.class || need == Byte.TYPE && have == Byte.class || need == Short.TYPE && have == Short.class || need == Character.TYPE && have == Character.class || need == Integer.TYPE && have == Integer.class || need == Long.TYPE && have == Long.class || need == Float.TYPE && have == Float.class || need == Double.TYPE && have == Double.class;
    }
}

