/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.api;

import java.util.Comparator;

public enum ValueType implements Comparator<ValueType>
{
    LONG(Long.TYPE, 1),
    INT(Integer.TYPE, 2),
    FLOAT(Float.TYPE, 3),
    DOUBLE(Double.TYPE, 4),
    BOOLEAN(Boolean.TYPE, 5),
    BYTE(Byte.TYPE, 6),
    STRING(String.class, 7),
    OBJECT(Object.class, 8);

    private final Class<?> clazz;
    private int precedence;

    private ValueType(Class<?> clazz, int precedence) {
        this.clazz = clazz;
        this.precedence = precedence;
    }

    public String getSimpleName() {
        return this.clazz.getSimpleName();
    }

    public static ValueType valueOfClassName(String typeName) {
        if (typeName == null) {
            return null;
        }
        for (ValueType valueType : ValueType.values()) {
            if (!valueType.clazz.getSimpleName().equals(typeName)) continue;
            return valueType;
        }
        return OBJECT;
    }

    public static Class<?> classOfType(String inputType) {
        if (inputType == null) {
            return null;
        }
        ValueType valueType = ValueType.valueOfClassName(inputType);
        if (valueType == null) {
            return null;
        }
        if (valueType == OBJECT) {
            try {
                return Class.forName(inputType);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to determine class for type " + inputType + ". Consider adding the full package to the name.");
            }
        }
        return valueType.getValueClass();
    }

    public static ValueType valueOfAssignableClass(Class<?> clazz) {
        for (ValueType valueType : ValueType.values()) {
            if (!valueType.clazz.isAssignableFrom(clazz)) continue;
            return valueType;
        }
        throw new RuntimeException("Unable to find a matching value type for " + clazz);
    }

    @Override
    public int compare(ValueType o1, ValueType o2) {
        return Integer.compare(o1.precedence, o2.precedence);
    }

    public Class<?> getValueClass() {
        return this.clazz;
    }
}

