/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.lang.ast;

import io.nosqlbench.virtdata.lang.ast.ArgType;
import io.nosqlbench.virtdata.lang.ast.BooleanArg;
import io.nosqlbench.virtdata.lang.ast.DoubleArg;
import io.nosqlbench.virtdata.lang.ast.FloatArg;
import io.nosqlbench.virtdata.lang.ast.IntegerArg;
import io.nosqlbench.virtdata.lang.ast.LongArg;
import io.nosqlbench.virtdata.lang.ast.RefArg;
import io.nosqlbench.virtdata.lang.ast.StringArg;
import io.nosqlbench.virtdata.lang.ast.VariableRef;
import java.util.ArrayList;
import java.util.List;

public class FunctionCall
implements ArgType {
    private String funcName;
    private List<ArgType> args = new ArrayList<ArgType>();
    private String inputType;
    private String outputType;
    private String inputClass;

    public FunctionCall() {
    }

    public FunctionCall(String funcName) {
        this.funcName = funcName;
    }

    public FunctionCall(String inputType, String funcName) {
        this.inputType = inputType;
        this.funcName = funcName;
    }

    public void addFunctionArg(ArgType argType) {
        this.args.add(argType);
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public void setFuncName(String funcName) {
        this.funcName = funcName;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(this.inputType == null ? "" : this.inputType + "->"));
        sb.append(this.funcName);
        sb.append("(");
        String sep = "";
        for (ArgType arg : this.args) {
            sb.append(sep);
            sb.append(arg);
            sep = ",";
        }
        sb.append(")");
        sb.append((String)(this.outputType == null ? "" : "->" + this.outputType));
        return sb.toString();
    }

    public FunctionCall getVirtdataCall(int i) {
        return (FunctionCall)this.args.get(i);
    }

    public String getFunctionName() {
        return this.funcName;
    }

    public String getInputType() {
        return this.inputType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public List<ArgType> getArgs() {
        return this.args;
    }

    public Object[] getArguments() {
        ArrayList<Object> args = new ArrayList<Object>();
        block10: for (ArgType argType : this.getArgs()) {
            ArgType.TypeName typeName = ArgType.TypeName.valueOf(argType);
            switch (typeName) {
                case RefArg: {
                    args.add(new VariableRef(((RefArg)argType).getRefName()));
                    continue block10;
                }
                case FunctionCall: {
                    args.add(argType);
                    continue block10;
                }
                case StringArg: {
                    args.add(((StringArg)argType).getStringValue());
                    continue block10;
                }
                case FloatArg: {
                    args.add(((FloatArg)argType).getFloatValue());
                    continue block10;
                }
                case IntegerArg: {
                    args.add(((IntegerArg)argType).getIntValue());
                    continue block10;
                }
                case LongArg: {
                    args.add(((LongArg)argType).getLongValue());
                    continue block10;
                }
                case DoubleArg: {
                    args.add(((DoubleArg)argType).getDoubleValue());
                    continue block10;
                }
                case BooleanArg: {
                    args.add(((BooleanArg)argType).getBooleanValue());
                    continue block10;
                }
            }
            throw new RuntimeException("Could not map type into argument object: " + typeName);
        }
        return args.toArray();
    }
}

