/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.lang.ast;

import io.nosqlbench.virtdata.lang.ast.ArgType;

public class StringArg
implements ArgType {
    private final String rawEscapedText;
    private final String unEscapedText;

    public StringArg(String rawEscapedText) {
        this.rawEscapedText = rawEscapedText;
        this.unEscapedText = StringArg.unEscape(rawEscapedText);
    }

    private static String unEscape(String value) {
        String innervalue = value.substring(1, value.length() - 1);
        if (value.startsWith("\"")) {
            innervalue = innervalue.replaceAll("\\\\(.)", "$1");
        }
        return innervalue;
    }

    public String getRawValue() {
        return this.rawEscapedText;
    }

    public String getStringValue() {
        return this.unEscapedText;
    }

    public String toString() {
        return "'" + this.unEscapedText + "'";
    }
}

