/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.random;

import io.nosqlbench.virtdata.annotations.DeprecatedFunction;
import io.nosqlbench.virtdata.api.VirtDataResources;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomLineToString
implements LongFunction<String> {
    private static final Logger logger = LogManager.getLogger(RandomLineToString.class);
    private List<String> lines = new ArrayList<String>();
    private final MersenneTwister rng;
    private final IntegerDistribution itemDistribution;
    private final String filename;

    public RandomLineToString(String filename) {
        this.rng = new MersenneTwister(System.nanoTime());
        this.filename = filename;
        this.lines = VirtDataResources.readDataFileLines(filename);
        this.itemDistribution = new UniformIntegerDistribution(this.rng, 0, this.lines.size() - 2);
    }

    public RandomLineToString(String filename, MersenneTwister rng) {
        this.rng = rng;
        this.filename = filename;
        this.lines = VirtDataResources.readDataFileLines(filename);
        this.lines = VirtDataResources.readDataFileLines(filename);
        this.itemDistribution = new UniformIntegerDistribution(rng, 0, this.lines.size() - 2);
    }

    public RandomLineToString(String filename, long seed) {
        this.rng = new MersenneTwister(seed);
        this.filename = filename;
        this.lines = VirtDataResources.readDataFileLines(filename);
        this.itemDistribution = new UniformIntegerDistribution(this.rng, 0, this.lines.size() - 2);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.filename;
    }

    @Override
    public String apply(long operand) {
        int itemIdx = this.itemDistribution.sample();
        String item = this.lines.get(itemIdx);
        return item;
    }
}

