/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.random;

import io.nosqlbench.virtdata.annotations.DeprecatedFunction;
import io.nosqlbench.virtdata.library.random.RandomLineToString;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongFunction;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.random.MersenneTwister;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomLineToStringMap
implements LongFunction<Map<String, String>> {
    private final RandomLineToString lineDataMapper;
    private final IntegerDistribution sizeDistribution;
    private final MersenneTwister rng;

    public RandomLineToStringMap(String paramFile, int maxSize) {
        this.rng = new MersenneTwister(System.nanoTime());
        this.sizeDistribution = new UniformIntegerDistribution(this.rng, 0, maxSize - 1);
        this.lineDataMapper = new RandomLineToString(paramFile);
    }

    public RandomLineToStringMap(String paramFile, int maxSize, long seed) {
        this.rng = new MersenneTwister(seed);
        this.sizeDistribution = new UniformIntegerDistribution(this.rng, 0, maxSize - 1);
        this.lineDataMapper = new RandomLineToString(paramFile);
    }

    @Override
    public Map<String, String> apply(long input) {
        int mapSize = this.sizeDistribution.sample();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int idx = 0; idx < mapSize; ++idx) {
            map.put(this.lineDataMapper.apply(input), this.lineDataMapper.apply(input));
        }
        return map;
    }
}

