/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.random;

import io.nosqlbench.virtdata.annotations.DeprecatedFunction;
import io.nosqlbench.virtdata.library.random.RandomLineToStringMap;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomLinesToKeyValueString
implements LongFunction<String> {
    private static final Logger logger = LogManager.getLogger(RandomLinesToKeyValueString.class);
    private final RandomLineToStringMap lineDataMapper;
    private final MersenneTwister rng;

    public RandomLinesToKeyValueString(String paramFile, int maxSize) {
        this(paramFile, maxSize, System.nanoTime());
    }

    public RandomLinesToKeyValueString(String paramFile, int maxsize, long seed) {
        this.rng = new MersenneTwister(seed);
        this.lineDataMapper = new RandomLineToStringMap(paramFile, maxsize);
    }

    @Override
    public String apply(long input) {
        Object stringStringMap = this.lineDataMapper.apply(input);
        String mapstring = stringStringMap.entrySet().stream().map(es -> (String)es.getKey() + ":" + (String)es.getValue() + ";").collect(Collectors.joining());
        return mapstring;
    }
}

