/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.random;

import io.nosqlbench.virtdata.annotations.DeprecatedFunction;
import java.util.function.LongFunction;
import org.apache.commons.math3.random.MersenneTwister;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomRangedToInt
implements LongFunction<Integer> {
    private final MersenneTwister theTwister;
    private final long min;
    private final long max;
    private final long length;

    public RandomRangedToInt(long min, long max) {
        this(min, max, System.nanoTime());
    }

    public RandomRangedToInt(long min, long max, long seed) {
        this.theTwister = new MersenneTwister(seed);
        if (max <= min) {
            throw new RuntimeException("max must be >= min");
        }
        this.min = min;
        this.max = max;
        this.length = max - min;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.min + ":" + this.max;
    }

    @Override
    public Integer apply(long operand) {
        long value = Math.abs(this.theTwister.nextLong());
        value %= this.length;
        return (int)(value += this.min);
    }
}

