/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.random;

import io.nosqlbench.virtdata.annotations.DeprecatedFunction;
import java.util.function.LongUnaryOperator;
import org.apache.commons.math3.random.MersenneTwister;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomRangedToLong
implements LongUnaryOperator {
    private final MersenneTwister theTwister;
    private final long min;
    private final long max;
    private final long length;

    public RandomRangedToLong(long min, long max) {
        this(min, max, System.nanoTime());
    }

    public RandomRangedToLong(long min, long max, long seed) {
        this.theTwister = new MersenneTwister(seed);
        if (max <= min) {
            throw new RuntimeException("max must be >= min");
        }
        this.min = min;
        this.max = max;
        this.length = max - min;
    }

    @Override
    public long applyAsLong(long input) {
        long value = Math.abs(this.theTwister.nextLong());
        value %= this.length;
        return value += this.min;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.min + ":" + this.max;
    }
}

