/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.random;

import io.nosqlbench.virtdata.annotations.DeprecatedFunction;
import java.nio.ByteBuffer;
import java.util.function.LongFunction;
import org.apache.commons.math3.random.MersenneTwister;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomToByteBuffer
implements LongFunction<ByteBuffer> {
    private final MersenneTwister rng;
    private int length;

    public RandomToByteBuffer(int length) {
        this.length = length;
        this.rng = new MersenneTwister(System.nanoTime());
    }

    public RandomToByteBuffer(int length, long seed) {
        this.length = length;
        this.rng = new MersenneTwister(seed);
    }

    @Override
    public ByteBuffer apply(long input) {
        byte[] buffer = new byte[this.length];
        this.rng.nextBytes(buffer);
        return ByteBuffer.wrap(buffer);
    }
}

