/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.processors;

import io.nosqlbench.virtdata.annotations.Categories;
import io.nosqlbench.virtdata.annotations.Category;
import io.nosqlbench.virtdata.annotations.Example;
import io.nosqlbench.virtdata.annotations.PerThreadMapper;
import io.nosqlbench.virtdata.annotations.ThreadSafeMapper;
import io.nosqlbench.virtdata.processors.DocForFunc;
import io.nosqlbench.virtdata.processors.FuncEnumerator;
import io.nosqlbench.virtdata.processors.FunctionDocInfoWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedOptions(value={"title"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
@SupportedAnnotationTypes(value={"io.nosqlbench.virtdata.annotations.ThreadSafeMapper", "io.nosqlbench.virtdata.annotations.PerThreadMapper"})
public class FunctionDocInfoProcessor
extends AbstractProcessor {
    public static final String AUTOSUFFIX = "AutoDocsInfo";
    private static Pattern packageNamePattern = Pattern.compile("(?<packageName>.+)?\\.(?<className>.+)");
    private Filer filer;
    private Map<String, String> options;
    private Elements elementUtils;
    private Messager messenger;
    private SourceVersion sourceVersion;
    private Types typeUtils;
    private FuncEnumerator enumerator;
    private static Pattern inheritDocPattern = Pattern.compile("(?ms)(?<pre>.*)(?<inherit>\\{@inheritDoc})(?<post>.*)$");

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.options = processingEnv.getOptions();
        this.elementUtils = processingEnv.getElementUtils();
        this.messenger = processingEnv.getMessager();
        this.sourceVersion = processingEnv.getSourceVersion();
        this.typeUtils = processingEnv.getTypeUtils();
        this.enumerator = new FuncEnumerator(this.typeUtils, this.elementUtils, this.filer);
        this.enumerator.addListener(new FunctionDocInfoWriter(this.filer, this.messenger, AUTOSUFFIX));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ArrayList<Element> ts = new ArrayList<Element>();
        ts.addAll(roundEnv.getElementsAnnotatedWith(ThreadSafeMapper.class));
        ts.addAll(roundEnv.getElementsAnnotatedWith(PerThreadMapper.class));
        for (Element classElem : ts) {
            if (classElem.getKind() != ElementKind.CLASS) {
                throw new RuntimeException("Unexpected kind of element: " + classElem.getKind() + " for " + classElem.toString());
            }
            Name qualifiedName = ((TypeElement)classElem).getQualifiedName();
            Matcher pnm = packageNamePattern.matcher(qualifiedName);
            if (!pnm.matches()) {
                throw new RuntimeException("Unable to match qualified name for package and name: " + qualifiedName);
            }
            String packageName = pnm.group("packageName");
            String simpleClassName = pnm.group("className");
            String classDoc = this.elementUtils.getDocComment(classElem);
            classDoc = classDoc == null ? "" : this.cleanJavadoc(classDoc);
            classDoc = this.inheritDocs(classDoc, classElem);
            this.enumerator.onClass(packageName, simpleClassName, classDoc);
            Categories categoryAnnotation = classElem.getAnnotation(Categories.class);
            if (categoryAnnotation != null) {
                Category[] value = categoryAnnotation.value();
                this.enumerator.onCategories(value);
            }
            boolean foundApply = false;
            Element applyMethodElem = null;
            Element applyInClassElem = classElem;
            while (applyMethodElem == null && applyInClassElem != null) {
                for (Element element : applyInClassElem.getEnclosedElements()) {
                    if (element.getKind() != ElementKind.METHOD || !element.getSimpleName().toString().startsWith("apply")) continue;
                    applyMethodElem = element;
                    break;
                }
                if (applyMethodElem != null) break;
                applyInClassElem = this.elementUtils.getTypeElement(((TypeElement)applyInClassElem).getSuperclass().toString());
            }
            if (applyMethodElem == null) {
                this.messenger.printMessage(Diagnostic.Kind.ERROR, "Unable to enumerate input and output types for " + simpleClassName);
                return false;
            }
            VariableElement inParam = ((ExecutableElement)applyMethodElem).getParameters().get(0);
            String string = inParam.asType().toString();
            String outType = ((ExecutableElement)applyMethodElem).getReturnType().toString();
            this.enumerator.onApplyTypes(string, outType);
            for (Element element : classElem.getEnclosedElements()) {
                Example[] exampleAnnotations;
                if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
                List<? extends VariableElement> parameters = ((ExecutableElement)element).getParameters();
                LinkedHashMap<String, String> args = new LinkedHashMap<String, String>();
                boolean isVarArgs = ((ExecutableElement)element).isVarArgs();
                for (int i = 0; i < parameters.size(); ++i) {
                    VariableElement var = parameters.get(i);
                    String varName = var.getSimpleName().toString();
                    String varType = var.asType().toString() + (i == parameters.size() - 1 ? (isVarArgs ? "..." : "") : "");
                    args.put(varName, varType);
                }
                String ctorDoc = this.elementUtils.getDocComment(element);
                ctorDoc = ctorDoc == null ? "" : this.cleanJavadoc(ctorDoc);
                ArrayList<List<String>> exampleData = new ArrayList<List<String>>();
                for (Example example : exampleAnnotations = (Example[])element.getAnnotationsByType(Example.class)) {
                    example.value();
                    exampleData.add(Arrays.asList(example.value()));
                }
                this.enumerator.onConstructor(args, ctorDoc, exampleData);
            }
            this.enumerator.flush();
        }
        return false;
    }

    private String inheritDocs(String classDoc, Element classElem) {
        if (classDoc == null) {
            return null;
        }
        Matcher matcher = inheritDocPattern.matcher(classDoc);
        if (!matcher.matches()) {
            return classDoc;
        }
        StringBuilder docData = new StringBuilder();
        String pre = matcher.group("pre");
        String post = matcher.group("post");
        Optional<TypeElement> inheritFromElement = Optional.ofNullable(((TypeElement)classElem).getSuperclass()).map(String::valueOf).map(this.elementUtils::getTypeElement);
        if (!inheritFromElement.isPresent()) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, "Element " + classElem.toString() + " has '{@inheritDoc}', but a superclass was not found.");
            return pre + "UNABLE TO FIND ELEMENT TO INHERIT DOCS FROM for " + classElem.toString() + " " + post;
        }
        TypeElement inheritFromType = inheritFromElement.get();
        String inheritedDocs = this.elementUtils.getDocComment(inheritFromType);
        if (inheritedDocs == null) {
            this.messenger.printMessage(Diagnostic.Kind.ERROR, "javadocs are missing on " + inheritFromElement.toString() + ", but " + classElem.toString() + " is trying to inherit docs from it.");
            return pre + "UNABLE TO FIND INHERITED DOCS for " + classElem.toString() + " " + post;
        }
        if (inheritDocPattern.matcher(inheritedDocs).matches()) {
            return pre + this.inheritDocs(inheritedDocs, inheritFromType) + post;
        }
        return pre + inheritedDocs + post;
    }

    private String cleanJavadoc(String ctorDoc) {
        return ctorDoc.replaceAll("(?m)^ ", "");
    }

    private static class StdoutListener
    implements FuncEnumerator.Listener {
        private StdoutListener() {
        }

        @Override
        public void onFunctionModel(DocForFunc functionDoc) {
            System.out.println(functionDoc);
        }
    }
}

