/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.gpg;

import java.io.ByteArrayInputStream;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.gpg.AbstractGpgSigner;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GpgSigner
extends AbstractGpgSigner {
    private String executable;

    public GpgSigner(String executable) {
        this.executable = executable;
    }

    protected void generateSignatureForFile(File file, File signature) throws MojoExecutionException {
        Commandline cmd = new Commandline();
        if (StringUtils.isNotEmpty(this.executable)) {
            cmd.setExecutable(this.executable);
        } else {
            cmd.setExecutable("gpg" + (Os.isFamily("windows") ? ".exe" : ""));
        }
        if (this.args != null) {
            for (String arg : this.args) {
                cmd.createArg().setValue(arg);
            }
        }
        if (this.homeDir != null) {
            cmd.createArg().setValue("--homedir");
            cmd.createArg().setFile(this.homeDir);
        }
        if (this.useAgent) {
            cmd.createArg().setValue("--use-agent");
        } else {
            cmd.createArg().setValue("--no-use-agent");
        }
        ByteArrayInputStream in = null;
        if (null != this.passphrase) {
            cmd.createArg().setValue("--batch");
            cmd.createArg().setValue("--passphrase-fd");
            cmd.createArg().setValue("0");
            in = new ByteArrayInputStream(this.passphrase.getBytes());
        }
        if (null != this.keyname) {
            cmd.createArg().setValue("--local-user");
            cmd.createArg().setValue(this.keyname);
        }
        cmd.createArg().setValue("--armor");
        cmd.createArg().setValue("--detach-sign");
        if (!this.isInteractive) {
            cmd.createArg().setValue("--no-tty");
        }
        if (!this.defaultKeyring) {
            cmd.createArg().setValue("--no-default-keyring");
        }
        if (StringUtils.isNotEmpty(this.secretKeyring)) {
            cmd.createArg().setValue("--secret-keyring");
            cmd.createArg().setValue(this.secretKeyring);
        }
        if (StringUtils.isNotEmpty(this.publicKeyring)) {
            cmd.createArg().setValue("--keyring");
            cmd.createArg().setValue(this.publicKeyring);
        }
        if ("once".equalsIgnoreCase(this.lockMode)) {
            cmd.createArg().setValue("--lock-once");
        } else if ("multiple".equalsIgnoreCase(this.lockMode)) {
            cmd.createArg().setValue("--lock-multiple");
        } else if ("never".equalsIgnoreCase(this.lockMode)) {
            cmd.createArg().setValue("--lock-never");
        }
        cmd.createArg().setValue("--output");
        cmd.createArg().setFile(signature);
        cmd.createArg().setFile(file);
        try {
            int exitCode = CommandLineUtils.executeCommandLine(cmd, in, (StreamConsumer)new DefaultConsumer(), new DefaultConsumer());
            if (exitCode != 0) {
                throw new MojoExecutionException("Exit code: " + exitCode);
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute gpg command", e);
        }
    }
}

