/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.library.random;

import io.nosqlbench.nb.api.content.NBIO;
import io.nosqlbench.virtdata.api.annotations.DeprecatedFunction;
import java.nio.CharBuffer;
import java.util.function.LongFunction;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.UniformIntegerDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@DeprecatedFunction(value="random mappers are not deterministic. They will be replaced with hash-based functions.")
public class RandomFileExtractToString
implements LongFunction<String> {
    private static final Logger logger = LogManager.getLogger(RandomFileExtractToString.class);
    private static CharBuffer fileDataImage = null;
    private int minsize;
    private int maxsize;
    private final MersenneTwister rng;
    private final IntegerDistribution sizeDistribution;
    private final IntegerDistribution positionDistribution;
    private final String fileName;

    public RandomFileExtractToString(String fileName, int minsize, int maxsize) {
        this(fileName, minsize, maxsize, System.nanoTime());
    }

    public RandomFileExtractToString(String fileName, int minsize, int maxsize, long seed) {
        this.fileName = fileName;
        this.minsize = minsize;
        this.maxsize = maxsize;
        this.loadData();
        this.rng = new MersenneTwister(seed);
        this.sizeDistribution = new UniformIntegerDistribution((RandomGenerator)this.rng, minsize, maxsize);
        this.positionDistribution = new UniformIntegerDistribution((RandomGenerator)this.rng, 1, fileDataImage.limit() - maxsize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadData() {
        if (fileDataImage != null) return;
        Class<RandomFileExtractToString> clazz = RandomFileExtractToString.class;
        synchronized (RandomFileExtractToString.class) {
            CharBuffer image;
            if (fileDataImage != null) return;
            fileDataImage = image = NBIO.readCharBuffer((String)this.fileName, (String[])new String[0]);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String apply(long input) {
        int offset = this.positionDistribution.sample();
        int length = this.sizeDistribution.sample();
        String sub = null;
        try {
            sub = fileDataImage.subSequence(offset, offset + length).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sub;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.minsize + ":" + this.maxsize;
    }
}

