/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.userlibs.apps.docsapp;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.nosqlbench.virtdata.annotations.Category;
import io.nosqlbench.virtdata.api.VirtDataDocs;
import io.nosqlbench.virtdata.api.VirtDataResources;
import io.nosqlbench.virtdata.processors.DocFuncData;
import io.nosqlbench.virtdata.userlibs.apps.docsapp.fdocs.FDoc;
import io.nosqlbench.virtdata.userlibs.apps.docsapp.fdocs.FDocCat;
import io.nosqlbench.virtdata.userlibs.apps.docsapp.fdocs.FDocFunc;
import io.nosqlbench.virtdata.userlibs.apps.docsapp.fdocs.FDocFuncs;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoDocsApp
implements Runnable {
    private static final Logger logger = LogManager.getLogger(AutoDocsApp.class);
    private static final String CATEGORIES = "categories";
    private static final String CATEGORIES_SPLIT = "split";
    private static final String CATEGORIES_COMBINED = "combined";
    private static final String FORMAT = "format";
    private static final String FORMAT_MARKDOWN = "markdown";
    private static final String FORMAT_JSON = "json";
    private static final String BLURBS_DIRS = "blurbsdirs";
    private static final String BASE_FILENAME = "funcref";
    private final String[] args;
    private final Map<String, Writer> writers = new HashMap<String, Writer>();
    private String baseFileName = "funcref";
    private String categories = "split";
    private String format = "markdown";
    private String blurbsDirs = "docs/category_blurbs:src/main/resources/docs/category_blurbs:virtdata-userlibs/src/main/resources/docs/category_blurbs";
    private String basedir = "";

    public static void main(String[] args) {
        new AutoDocsApp(args).run();
    }

    public AutoDocsApp(String[] args) {
        this.args = args;
    }

    @Override
    public void run() {
        LinkedList<String> largs = new LinkedList<String>(Arrays.asList(this.args));
        if (this.args.length > 0 && this.args[0].contains("help")) {
            System.out.println("usage:\n[basefile <name>] [basedir <dir>] [categories combined|split] [format json|markdown] [blurbsdirs <dir>[:...]]\n\n");
            System.exit(0);
        }
        while (largs.peekFirst() != null) {
            String argtype = largs.removeFirst();
            if (largs.peekFirst() == null) {
                throw new RuntimeException(AutoDocsApp.class.toString() + " expects args in param value couplets.");
            }
            String argval = largs.removeFirst().toLowerCase();
            switch (argtype) {
                case "basefile": {
                    this.baseFileName = argval;
                    break;
                }
                case "basedir": {
                    this.basedir = argval;
                    break;
                }
                case "blurbsdirs": {
                    this.blurbsDirs = argval;
                    break;
                }
                case "categories": {
                    if (!argval.equals(CATEGORIES_SPLIT) && !argval.equals(CATEGORIES_COMBINED)) {
                        throw new RuntimeException("categories must either be split, or combined.");
                    }
                    this.categories = argval;
                    break;
                }
                case "format": {
                    if (!argval.equals(FORMAT_MARKDOWN) && !argval.equals(FORMAT_JSON)) {
                        throw new RuntimeException("format must either be markdown, or json.");
                    }
                    this.format = argval;
                    break;
                }
            }
        }
        FDoc docsinfo = this.loadAllDocs();
        try {
            String extension = this.format.equals(FORMAT_MARKDOWN) ? ".md" : ".json";
            for (FDocCat docsForCatName : docsinfo) {
                String categoryName = docsForCatName.getCategoryName();
                categoryName = categoryName.isEmpty() ? "EMPTY" : categoryName;
                String filename = this.baseFileName + (String)(this.categories.equals(CATEGORIES_SPLIT) ? "_" + categoryName : "") + extension;
                Writer writer = this.getWriterFor(filename);
                for (FDocFuncs docsForFuncName : docsForCatName) {
                    if (this.format.equals(FORMAT_JSON)) {
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        writer.append(gson.toJson((Object)docsForFuncName));
                        continue;
                    }
                    if (!this.format.equals(FORMAT_MARKDOWN)) continue;
                    writer.append(docsForFuncName.asMarkdown());
                }
            }
            for (Writer writer : this.writers.values()) {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Writer getWriterFor(String outputname) {
        FileWriter fileWriter = null;
        if (!this.writers.containsKey(outputname)) {
            try {
                String[] blurbsdirs;
                outputname = this.basedir.isEmpty() ? outputname : this.basedir + "/" + outputname;
                Path parent = Path.of(outputname, new String[0]).getParent();
                if (parent != null) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                fileWriter = new FileWriter(outputname, false);
                this.writers.put(outputname, fileWriter);
                for (String blurbsdir : blurbsdirs = this.blurbsDirs.split(":")) {
                    Path blurbsFile;
                    Optional bdir = VirtDataResources.FindOptionalPathIn((String[])new String[]{blurbsdir + "/"});
                    if (!bdir.isPresent() || !Files.exists(blurbsFile = ((Path)bdir.get()).resolve(Path.of(outputname, new String[0]).getFileName().toString()), new LinkOption[0])) continue;
                    String blurb = Files.readString(blurbsFile, StandardCharsets.UTF_8);
                    logger.debug("writing blurb to " + outputname);
                    fileWriter.append(blurb);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.writers.get(outputname);
    }

    private FDoc loadAllDocs() {
        FDoc docsinfo = new FDoc();
        List allDocs = VirtDataDocs.getAllDocs();
        for (DocFuncData docFuncData : allDocs) {
            FDocFunc FDocFunc2 = new FDocFunc(docFuncData);
            for (Category categoryName : FDocFunc2.getCategories()) {
                FDocCat fDocCat = docsinfo.addCategory(categoryName.toString());
                fDocCat.addFunctionDoc(FDocFunc2);
            }
        }
        return docsinfo;
    }
}

