/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.userlibs.apps.docsapp;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import io.nosqlbench.docsys.api.WebServiceObject;
import io.nosqlbench.virtdata.annotations.Service;
import io.nosqlbench.virtdata.api.VirtDataDocs;
import io.nosqlbench.virtdata.processors.DocFuncData;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Service(value=WebServiceObject.class)
@Singleton
@Path(value="/services/virtdata/functions/")
public class AutoDocsWebService
implements WebServiceObject {
    private static final Logger logger = LogManager.getLogger(AutoDocsWebService.class);
    private List<DocFuncData> _docs = VirtDataDocs.getAllDocs();

    @GET
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @Path(value="names")
    public List<String> getAutoDocsNames() {
        return VirtDataDocs.getAllNames();
    }

    @GET
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @Produces(value={"application/json"})
    @Path(value="details")
    public List<DocFuncData> getAutoDocsDetails(@QueryParam(value="function") String fname) {
        if (fname == null || fname.isEmpty()) {
            return this._docs;
        }
        return this._docs.stream().filter(d -> {
            String fullname = d.getPackageName() + "." + d.getClassName();
            return fullname.contains(fname);
        }).collect(Collectors.toList());
    }
}

