/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.virtdata.userlibs.apps.docsapp.fdocs;

import io.nosqlbench.virtdata.annotations.Category;
import io.nosqlbench.virtdata.processors.DocCtorData;
import io.nosqlbench.virtdata.processors.DocFuncData;
import io.nosqlbench.virtdata.userlibs.apps.docsapp.fdocs.FDocCtor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FDocFunc
implements Comparable<FDocFunc> {
    private final String funcName;
    private final Set<Category> categories;
    private String className;
    private String classJavaDoc;
    private String packageName;
    private List<FDocCtor> ctors;
    private String inType;
    private String outType;

    public FDocFunc(DocFuncData docFuncData) {
        this.funcName = docFuncData.getClassName();
        this.categories = new HashSet<Category>(Arrays.asList(docFuncData.getCategories()));
        this.className = docFuncData.getClassName();
        this.classJavaDoc = docFuncData.getClassJavadoc();
        this.packageName = docFuncData.getPackageName();
        this.inType = docFuncData.getInType();
        this.outType = docFuncData.getOutType();
        this.ctors = docFuncData.getCtors().stream().map(f -> new FDocCtor((DocCtorData)f, this.inType, this.outType)).collect(Collectors.toList());
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassJavaDoc() {
        return this.classJavaDoc;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getInType() {
        return this.inType;
    }

    public String getOutType() {
        return this.outType;
    }

    public String getFuncName() {
        return this.funcName;
    }

    public Set<Category> getCategories() {
        return this.categories;
    }

    @Override
    public int compareTo(FDocFunc o) {
        int result = this.className.compareTo(o.className);
        if (result != 0) {
            return result;
        }
        result = this.getPackageName().compareTo(o.getPackageName());
        return result;
    }

    public List<FDocCtor> getCtors() {
        return this.ctors;
    }

    public CharSequence asMarkdown() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }
}

